/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.block;

import dev.architectury.registry.menu.MenuRegistry;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.block.IBlock;
import owmii.powah.lib.block.IBlockEntity;
import owmii.powah.lib.logistics.inventory.AbstractContainer;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.lib.registry.IVariantEntry;

public class AbstractBlock<V extends IVariant, B extends AbstractBlock<V, B>>
extends Block
implements IVariantEntry<V, B>,
IBlock<V, B> {
    public static final VoxelShape SEMI_FULL_SHAPE = AbstractBlock.box(0.01, 0.01, 0.01, 15.99, 15.99, 15.99);
    protected final Map<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>();
    protected final V variant;

    public AbstractBlock(BlockBehaviour.Properties properties) {
        this(properties, IVariant.getEmpty());
    }

    public AbstractBlock(BlockBehaviour.Properties properties, V variant) {
        super(properties);
        this.variant = variant;
        this.shapes.put(Direction.UP, Shapes.m_83144_());
        this.shapes.put(Direction.DOWN, Shapes.m_83144_());
        this.shapes.put(Direction.NORTH, Shapes.m_83144_());
        this.shapes.put(Direction.SOUTH, Shapes.m_83144_());
        this.shapes.put(Direction.EAST, Shapes.m_83144_());
        this.shapes.put(Direction.WEST, Shapes.m_83144_());
    }

    public static VoxelShape box(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Block.m_49796_((double)Math.min(x1, x2), (double)Math.min(y1, y2), (double)Math.min(z1, z2), (double)Math.max(x1, x2), (double)Math.max(y1, y2), (double)Math.max(z1, z2));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (!this.shapes.isEmpty() && !this.getFacing().equals((Object)Facing.NONE)) {
            return this.shapes.get(state.m_61143_((Property)BlockStateProperties.f_61372_));
        }
        return super.m_5940_(state, worldIn, pos, context);
    }

    public Component getDisplayName(ItemStack stack) {
        return new TranslatableComponent(this.m_5456_().m_5671_(stack));
    }

    @Override
    public V getVariant() {
        return this.variant;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IBlockEntity) {
            ((IBlockEntity)tile).onAdded(world, state, oldState, isMoving);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IBlockEntity) {
            ((IBlockEntity)tile).onRemoved(world, state, newState, isMoving);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IBlockEntity) {
            ((IBlockEntity)tile).onPlaced(world, state, placer, stack);
        }
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        if (te instanceof AbstractTileEntity) {
            AbstractTileEntity tile = (AbstractTileEntity)te;
            ItemStack stack1 = tile.storeToStack(new ItemStack((ItemLike)this));
            AbstractBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack1);
            player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
            player.m_36399_(0.005f);
        } else {
            super.m_6240_(world, player, pos, state, te, stack);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (this instanceof SimpleWaterloggedBlock && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (!state.m_60710_((LevelReader)world, currentPos)) {
            BlockEntity tileEntity = world.m_7702_(currentPos);
            if (!world.m_5776_() && tileEntity instanceof AbstractTileEntity) {
                AbstractTileEntity tile = (AbstractTileEntity)tileEntity;
                ItemStack stack = tile.storeToStack(new ItemStack((ItemLike)this));
                AbstractBlock.m_49840_((Level)((Level)world), (BlockPos)currentPos, (ItemStack)stack);
                world.m_46961_(currentPos, false);
            }
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.getCloneItemStack(world, pos);
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof AbstractTileEntity) {
            AbstractTileEntity tile = (AbstractTileEntity)te;
            return tile.storeToStack(new ItemStack((ItemLike)this));
        }
        return new ItemStack((ItemLike)this);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, final BlockHitResult result) {
        MenuProvider provider;
        AbstractContainerMenu container;
        final BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof AbstractTileEntity && (container = (provider = new MenuProvider(){

            public Component m_5446_() {
                return new ItemStack((ItemLike)AbstractBlock.this).m_41786_();
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                return AbstractBlock.this.getContainer(i, playerInventory, (AbstractTileEntity)tile, result);
            }
        }).m_7208_(0, player.m_150109_(), player)) != null) {
            if (player instanceof ServerPlayer) {
                MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, buffer -> {
                    buffer.m_130064_(pos);
                    this.additionalGuiData((FriendlyByteBuf)buffer, state, world, pos, player, hand, result);
                });
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, result);
    }

    @Nullable
    public <T extends AbstractTileEntity> AbstractContainer getContainer(int id, Inventory inventory, AbstractTileEntity te, BlockHitResult result) {
        return null;
    }

    protected void additionalGuiData(FriendlyByteBuf buffer, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
    }

    public boolean m_7923_(BlockState state) {
        return !state.m_60815_();
    }

    protected void setDefaultState() {
        this.setStateProps(state -> state);
    }

    protected void setStateProps(BaseState baseState) {
        BlockState state = (BlockState)this.f_49792_.m_61090_();
        if (this instanceof SimpleWaterloggedBlock) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        }
        if (!this.getFacing().equals((Object)Facing.NONE)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH);
        }
        if (this.hasLitProp()) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(baseState.get(state));
    }

    protected boolean isPlacerFacing() {
        return false;
    }

    protected Facing getFacing() {
        return Facing.NONE;
    }

    protected boolean hasLitProp() {
        return false;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.m_5888_(state).m_76178_() || super.m_7420_(state, reader, pos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        if (this.getFacing().equals((Object)Facing.HORIZONTAL)) {
            state = !this.isPlacerFacing() ? this.facing(context, false) : (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)context.m_8125_().m_122424_());
        } else if (this.getFacing().equals((Object)Facing.ALL)) {
            state = !this.isPlacerFacing() ? this.facing(context, true) : (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)context.m_7820_().m_122424_());
        }
        if (state != null && this instanceof SimpleWaterloggedBlock) {
            FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return state;
    }

    @Nullable
    private BlockState facing(BlockPlaceContext context, boolean b) {
        BlockState blockstate = this.m_49966_();
        for (Direction direction : context.m_6232_()) {
            if (!b && !direction.m_122434_().m_122479_() || !(blockstate = (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)(b ? direction : direction.m_122424_()))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (this.getFacing().equals((Object)Facing.ALL) || this.getFacing().equals((Object)Facing.HORIZONTAL)) {
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
        }
        return super.m_6843_(state, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (this.getFacing().equals((Object)Facing.ALL) || this.getFacing().equals((Object)Facing.HORIZONTAL)) {
            return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
        }
        return super.m_6943_(state, mirror);
    }

    public FluidState m_5888_(BlockState state) {
        return this instanceof SimpleWaterloggedBlock && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int id, int param) {
        BlockEntity tileEntity = world.m_7702_(pos);
        return tileEntity != null && tileEntity.m_7531_(id, param);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.getFacing().equals((Object)Facing.ALL) || this.getFacing().equals((Object)Facing.HORIZONTAL)) {
            builder.m_61104_(new Property[]{BlockStateProperties.f_61372_});
        }
        if (this instanceof SimpleWaterloggedBlock) {
            builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        }
        if (this.hasLitProp()) {
            builder.m_61104_(new Property[]{BlockStateProperties.f_61443_});
        }
    }

    protected static enum Facing {
        HORIZONTAL,
        ALL,
        NONE;

    }

    protected static interface BaseState {
        public BlockState get(BlockState var1);
    }
}

